import AMPS
import json
import time
import uuid
from sets import Set
import threading

# Sample for a framework that skips processing of poison messages.

class MisterYuck:

   # Initialize the class with the template client,
   # and the handler to wrap.
   def __init__(self, client, handler):

       # Raise an exception if handler isn't callable.
       if callable(handler):
         self.handler = handler
       else:
         raise Exception("MisterYuck: provided handler is not callable.")

       # Initialize the list of messages to skip and
       # a lock to protect access.
       self.skipMessagesLock = threading.Lock()
       self.skipMessages = Set()
       self.handler = handler
       self.doneLoading = False
       #self.currentBookmark = None

       #create a new client to use for the admin subscription
       self.client = AMPS.Client("poison_monitor-%s" % uuid.uuid1())
       # Copy the connect string from the provided client
       self.client.connect(client.get_uri())
       self.client.logon()
       self.client.sow_and_subscribe(self.updatePoisonMessages,
                                     "ADMIN_PoisonMessages")
       # wait for the admin SOW query to complete
       while(self.doneLoading == False):
             time.sleep(.25)

   # Clean up the client used for updates.

   def __del__(self):
         # If the wrapper is being deleted while currentBookmark
         # is set, that indicates a serious error.
         if (self.curentBookmark != None and self.client != None):
             self.client.publish("ADMIN_PoisonMessages",
                        json.dumps( { "bookmark" : self.currentBookmark,
                                      "why" : "Fatal error." } ))
         self.close()

   # Gracefully close the client used for updates.
   
   def close(self):
      if (self.client != None):
          self.client.close()
          self.client = None
      self.handler = None
      self.currentBookmark = None

   

   # This method serves as the message handler for MisterYuck.
   # The method wraps the message handler provided to __init__, with
   # the following logic:
   #
   # * If the message is in the poison message list, skip it.
   # * Otherwise, call the wrapped handler
   # * If the wrapped handler throws an exception, publish information
   #   about the message to the poison message catalog

   def __call__(self, m):
        self.currentBookmark = m.get_bookmark() 

        # Process the message if it's not on the skip list
        with self.skipMessagesLock:
            if self.currentBookmark in self.skipMessages:
                print "Trace: skipping bad bookmark (%s)" % self.currentBookmark
                self.currentBookmark = None
                return

        try:
          self.handler(m)

        except Exception as e:
          self.client.publish("ADMIN_PoisonMessages",
                       json.dumps( { "bookmark" : currentBookmark,
                                     "why" : "%s" % e ,
                                     "contents" : "%s" % m.get_data() } ))
          print "Trace: logged a bad message: %s" % m.get_data()
          raise
        finally:
          self.currentBookmark = None

             
   # This is the message handler for the sow_and_subscribe command that
   # monitors the poison message catalog. Any time a message arrives,
   # whether it's part of the SOW query or a new update, add the information
   # from that message to the list of messages to avoid.
   def updatePoisonMessages(self, m):
        if (m.get_command() == "group_begin"):
            return
        if (m.get_command() == "group_end"):
            self.doneLoading = True 
            return
        print "Trace: Updating poison message dictionary!"
        with self.skipMessagesLock:
            self.skipMessages.add(json.loads(m.get_data())["bookmark"])


